﻿using System;
using System.Collections.Generic;
using System.Text;

namespace TemplatePatternDemo
{
    public abstract class Appointments
    {
        /// <summary>
        /// handles the appointment process
        /// </summary>
        public void ProcessAppointment()
        {
            ScheduleAppointment();
            SignPatientIn();
            ScreenPatient();
            DiagnosePatient();
            TreatPatient();
        }

        /// <summary>
        /// set appointment date and time
        /// </summary>
        public virtual void ScheduleAppointment()
        {
            Console.WriteLine("Brak umówionego spotkania - nagły przypadek lub umówienie terminu");
        }

        /// <summary>
        /// patient shows up and signs in
        /// </summary>
        public abstract void SignPatientIn();

        /// <summary>
        /// do preliminary screening
        /// </summary>
        public abstract void ScreenPatient();

        /// <summary>
        /// doctor performs diagnosis
        /// </summary>
        public virtual void DiagnosePatient()
        {
            Console.WriteLine("Diagnoza pacjenta została zapisana w pliku.");
        }

        /// <summary>
        /// doctor cures patient
        /// </summary>
        public abstract void TreatPatient();
    }
}
